<?php /*?>https://developers.google.com/maps/documentation/javascript/examples/geocoding-simple<?php */?>

<!DOCTYPE html>
<html>
<head>
<title>Geocoding Service</title>
<meta name="viewport" content="initial-scale=1.0, user-scalable=no">
<meta charset="utf-8">
<style>
/* Always set the map height explicitly to define the size of the div
* element that contains the map. */
#map {
height: 100%;
}
/* Optional: Makes the sample page fill the window. */
html, body {
height: 100%;
margin: 0;
padding: 0;
}
#floating-panel {
position: absolute;
top: 10px;
left: 1%;
z-index: 5;
background-color: #fff;
padding: 5px;
border: 1px solid #999;
text-align: center;
font-family: 'Roboto','sans-serif';
line-height: 30px;
padding-left: 10px;
}
#floating-panel div {padding:5px;}
</style>
</head>
<body>
<div id="floating-panel">
<input id="address" type="textbox" value="2 s. new lane sioux falls">
<input id="submit" type="button" value="Search Address">

<br/>
<input type="button" name="button_clear_map" value="Clear Map" onClick="return clear_overlays()">
<input type="button" name="button_predefined_rectangle" value="Pre-Defined Rectangle" onClick="return predefined_rectangle(200,100)">
<input type="button" name="button_predefined_circle" value="Pre-Defined Circle" onClick="return predefined_circle(100)">
<br/>

Area<br/>
<div style="height:170px; border:1px solid grey; text-align:left" id="container_display_area"></div>
Perimeter<br/>
<div style="height:100px; border:1px solid grey; text-align:left" id="container_display_perimeter"></div>
</div>

<div id="map"></div>

<script>

//
var map;
var drawingManager;
var markersArray = new Array();
//

//load map......................................................................................................................
function initMap() {

//
map = new google.maps.Map(document.getElementById('map'), {
zoom: 18,
center: {lat: 43.5427, lng: -96.6905},
mapTypeId: 'hybrid'
});

var geocoder = new google.maps.Geocoder();

//
document.getElementById('submit').addEventListener('click', function() {
geocodeAddress(geocoder, map);
});




//drawing manager.............................................................................................................
drawingManager = new google.maps.drawing.DrawingManager({
drawingMode: google.maps.drawing.OverlayType.MARKER,
drawingControl: true,
drawingControlOptions: {
position: google.maps.ControlPosition.TOP_CENTER,
drawingModes: ['circle', 'polygon', 'rectangle']
//drawingModes: ['marker', 'circle', 'polygon', 'polyline', 'rectangle']
},
markerOptions: {icon: 'https://developers.google.com/maps/documentation/javascript/examples/full/images/beachflag.png'},
markerOptions: {
  clickable: true,
  dragabble: true,
  editable: true
},
circleOptions: {
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
clickable: true,
editable: true,
draggable: true,
zIndex: 1
},
rectangleOptions: {
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
clickable: true,
editable: true,
draggable: true,
zIndex: 1
},
polygonOptions: {
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
clickable: true,
editable: true,
draggable: true,
zIndex: 1
}
});

//
drawingManager.setMap(map);


//area calculate#######################################################################
google.maps.event.addListener(drawingManager, 'overlaycomplete', function(event) {

//alert(event.type);
//.......................................................................
markersArray.push(event.overlay);
google.maps.event.addListener(event.overlay,"click",function(){});
//.......................................................................

//circle.....................................
if (event.type == 'circle') {
var radius = event.overlay.getRadius();
var area_meter_square=3.142*radius*radius;
var perimeter_meter=2*3.142*radius;
//alert("Area(in square meters) is approximately: "+area.toFixed(0));
//alert("Radius of circle(meters): "+radius);
}
//end circle.....................................

//rectangle.....................................................................................
if (event.type == 'rectangle') 
{
/*area = google.maps.geometry.spherical.computeArea(event.overlay.getBounds());
alert("Area(in square meters) is approximately: "+area.toFixed(0));*/

//get lat/lng bounds of the current shape
var bounds = event.overlay.getBounds();
var sw = bounds.getSouthWest();
var ne = bounds.getNorthEast();
var southWest = new google.maps.LatLng(sw.lat(), sw.lng());
var northEast = new google.maps.LatLng(ne.lat(), ne.lng());
var southEast = new google.maps.LatLng(sw.lat(), ne.lng());
var northWest = new google.maps.LatLng(ne.lat(), sw.lng());
var area_meter_square=google.maps.geometry.spherical.computeArea([northEast, northWest, southWest, southEast]);
var perimeter_meter=google.maps.geometry.spherical.computeLength([northEast, northWest, southWest, southEast]);
//alert("Area(in square meters) is approximately: "+area.toFixed(0));

/*var bounds = event.overlay.getBounds();
var start = bounds.getNorthEast();
var end = bounds.getSouthWest();
var center = bounds.getCenter();
alert(start);*/

}
//end rectangle..................................................................................

//polygon.....................................................................................
if (event.type == 'polygon') 
{
area_meter_square = google.maps.geometry.spherical.computeArea(event.overlay.getPath());
perimeter_meter = google.maps.geometry.spherical.computeLength(event.overlay.getPath());
//alert("Area(in square meters) is approximately: "+polygonArea.toFixed(0));
}
//end polygon.................................................................................


//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);



//after overlaycomplete listener for area change#################################################################################
//disable draw tool
drawingManager.setDrawingMode(null);
//Here the new code
var new_shape = event.overlay;

//alert(event.type);

//rectangle recalculate area------------------------------------------------------------------------------------------------
google.maps.event.addListener(new_shape, "bounds_changed", function() {
//
var bounds = new_shape.getBounds();
var sw = bounds.getSouthWest();
var ne = bounds.getNorthEast();
var southWest = new google.maps.LatLng(sw.lat(), sw.lng());
var northEast = new google.maps.LatLng(ne.lat(), ne.lng());
var southEast = new google.maps.LatLng(sw.lat(), ne.lng());
var northWest = new google.maps.LatLng(ne.lat(), sw.lng());
var area_meter_square=google.maps.geometry.spherical.computeArea([northEast, northWest, southWest, southEast]);
var perimeter_meter=google.maps.geometry.spherical.computeLength([northEast, northWest, southWest, southEast]);
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});
//end rectangle recalculate area--------------------------------------------------------------------------------------------


//polygon recalculate area------------------------------------------------------------------------------------------------
google.maps.event.addListener(new_shape, "mousemove", function() {
//
area_meter_square = google.maps.geometry.spherical.computeArea(event.overlay.getPath());
perimeter_meter = google.maps.geometry.spherical.computeLength(event.overlay.getPath());
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});
//end polygon recalculate area--------------------------------------------------------------------------------------------


//end after overlaycomplete listener for area change###########################################################################


//get lat/lng array of the current shape
//var locations = event.overlay.getPath().getArray();
//alert(locations);

//var area=event.overlay.computeArea();
//alert(area);

});
//end area calculate###################################################################

/*google.maps.event.addListener(drawingManager, 'polygoncomplete', function(event){
alert("hi"); 
}); */


/*google.maps.event.addListener(drawingManager, '', function(event) {
alert("hi");
});*/

//end drawing manager.............................................................................................................


}
//end load map................................................................................................................



//display perimeter...........................................................................................................
function display_perimeter(perimeter_meter)
{

//meter
perimeter_meter=perimeter_meter.toFixed(2);
perimeter_meter_display=perimeter_meter+" meter";
//feet
perimeter_feet=perimeter_meter*3.28084;
perimeter_feet_display=perimeter_feet.toFixed(2)+" feet";
//yards
perimeter_yards=perimeter_meter*1.09361;
perimeter_yards_display=perimeter_yards.toFixed(2)+" yards";

//
var perimeter_display=perimeter_feet_display+"<br/>"+perimeter_yards_display+"<br/>"+perimeter_meter_display;
document.getElementById("container_display_perimeter").innerHTML=perimeter_display;

}
//end display perimeter...........................................................................................................




//end display area...............................................................................................................
function display_area(area_meter_square)
{

var str='2';
//meter
area_meter_square=area_meter_square.toFixed(2);
area_meter_display=area_meter_square+" meter"+str.sup();
//feet
area_feet_square=area_meter_square*10.7639;
area_feet_display=area_feet_square.toFixed(2)+" feet"+str.sup();
//yards
area_yards_square=area_meter_square*1.19599;
area_yards_display=area_yards_square.toFixed(2)+" yards"+str.sup();
//acre
area_acre_square=area_meter_square/4046.856;
area_acre_display=area_acre_square.toFixed(2)+" acre";
//hectare
area_hectare_square=area_meter_square*0.0001;
area_hectare_display=area_hectare_square.toFixed(2)+" hectare";

//
var area_display=area_feet_display+"<br/>"+area_yards_display+"<br/>"+area_acre_display+"<br/>"+area_hectare_display+"<br/>"+area_meter_display;
document.getElementById("container_display_area").innerHTML=area_display;

}
//end display area...............................................................................................................




//-----------------------------------------------------------------------------------------------------------------------------
function predefined_circle(radius)
{

var circle = new google.maps.Circle({
center: map.getCenter(),
radius: radius,
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
editable: true,
clickable: true,
zIndex: 1
});

circle.setMap(map);

//
area_meter_square = Math.PI*radius*radius;
perimeter_meter = 2*Math.PI*radius;

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

//disable draw tool
//rectangle.setDrawingMode(null);
drawingManager.setDrawingMode(null);
//Here the new code
//var new_shape = rectangle.overlay;

//alert(event.type);

//circle recalculate area------------------------------------------------------------------------------------------------
google.maps.event.addListener(circle, "radius_changed", function() {
//
radius=circle.getRadius();
area_meter_square = Math.PI*radius*radius;
perimeter_meter = 2*Math.PI*radius;
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});
//end circle recalculate area--------------------------------------------------------------------------------------------


}
//end predefined_circle---------------------------------------------------------------------------------------------------



//-----------------------------------------------------------------------------------------------------------------------------
function predefined_rectangle(width,height)
{

//width=width/2;
//height=height/2;
//alert('hi');

//1 degree=364320 feet
var width_degree=width/364320;
var height_degree=height/364320;
//alert("width_degree: "+width_degree+", height_degree: "+height_degree);

var mylat = map.getCenter().lat(); 
var mylng = map.getCenter().lng();
//alert(mylat+', '+mylng);

var north=mylat+height_degree;
var south=mylat-height_degree;
var east=mylng+width_degree;
var west=mylng-width_degree;

//alert(north+', '+south+', '+east+', '+west);

var bounds = {
  north: north,
  south: south,
  east: east,
  west: west
};

// Define a rectangle and set its editable property to true.
var rectangle = new google.maps.Rectangle({
bounds: bounds,
fillColor: '#000000',
fillOpacity: 0.3,
strokeColor: 'yellow',
strokeWeight: 1,
editable: true,
clickable: true,
zIndex: 1
});

rectangle.setMap(map);

//
var bounds = rectangle.getBounds();
var sw = bounds.getSouthWest();
var ne = bounds.getNorthEast();
var southWest = new google.maps.LatLng(sw.lat(), sw.lng());
var northEast = new google.maps.LatLng(ne.lat(), ne.lng());
var southEast = new google.maps.LatLng(sw.lat(), ne.lng());
var northWest = new google.maps.LatLng(ne.lat(), sw.lng());
var area_meter_square=google.maps.geometry.spherical.computeArea([northEast, northWest, southWest, southEast]);
var perimeter_meter=google.maps.geometry.spherical.computeLength([northEast, northWest, southWest, southEast]);

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

//disable draw tool
//rectangle.setDrawingMode(null);
drawingManager.setDrawingMode(null);
//Here the new code
//var new_shape = rectangle.overlay;

//alert(event.type);

//rectangle recalculate area------------------------------------------------------------------------------------------------
google.maps.event.addListener(rectangle, "bounds_changed", function() {
//
var bounds = rectangle.getBounds();
var sw = bounds.getSouthWest();
var ne = bounds.getNorthEast();
var southWest = new google.maps.LatLng(sw.lat(), sw.lng());
var northEast = new google.maps.LatLng(ne.lat(), ne.lng());
var southEast = new google.maps.LatLng(sw.lat(), ne.lng());
var northWest = new google.maps.LatLng(ne.lat(), sw.lng());
var area_meter_square=google.maps.geometry.spherical.computeArea([northEast, northWest, southWest, southEast]);
var perimeter_meter=google.maps.geometry.spherical.computeLength([northEast, northWest, southWest, southEast]);
//

//area
display_area(area_meter_square);
display_perimeter(perimeter_meter);

});
//end rectangle recalculate area--------------------------------------------------------------------------------------------


}
//end predefined_rectangle---------------------------------------------------------------------------------------------------




//----------------------------------------------------------------------------------------------------------------------------
function clear_overlays()
{

for (var i = 0; i < markersArray.length; i++ ) 
{
    markersArray[i].setMap(null);
}

markersArray.length = 0;

}
//----------------------------------------------------------------------------------------------------------------------------



//get address-----------------------------------------------------------------------------------------------------------------
function geocodeAddress(geocoder, resultsMap) {
var address = document.getElementById('address').value;
geocoder.geocode({'address': address}, function(results, status) {
if (status === 'OK') {
resultsMap.setCenter(results[0].geometry.location);
var marker = new google.maps.Marker({
  map: resultsMap,
  position: results[0].geometry.location
});
} else {
alert('Geocode was not successful for the following reason: ' + status);
}
});
}
//end get address-------------------------------------------------------------------------------------------------------------


</script>


<script async defer
src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDTwbEnr61ZMGwD5kC89JULP2gCJpqhYow&libraries=places,drawing,geometry&callback=initMap">
</script>


</body>
</html>